/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.scores;

import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.numbers.NumberFormat;
import net.minecraft.network.chat.numbers.NumberFormatTypes;
import net.minecraft.world.scores.ReadOnlyScoreInfo;

public class Score
implements ReadOnlyScoreInfo {
    private static final String TAG_SCORE = "Score";
    private static final String TAG_LOCKED = "Locked";
    private static final String TAG_DISPLAY = "display";
    private static final String TAG_FORMAT = "format";
    private int value;
    private boolean locked = true;
    @Nullable
    private Component display;
    @Nullable
    private NumberFormat numberFormat;

    @Override
    public int value() {
        return this.value;
    }

    public void value(int p_313791_) {
        this.value = p_313791_;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean p_83399_) {
        this.locked = p_83399_;
    }

    @Nullable
    public Component display() {
        return this.display;
    }

    public void display(@Nullable Component p_313838_) {
        this.display = p_313838_;
    }

    @Override
    @Nullable
    public NumberFormat numberFormat() {
        return this.numberFormat;
    }

    public void numberFormat(@Nullable NumberFormat p_313931_) {
        this.numberFormat = p_313931_;
    }

    public CompoundTag write(HolderLookup.Provider p_330377_) {
        CompoundTag $$1 = new CompoundTag();
        $$1.putInt(TAG_SCORE, this.value);
        $$1.putBoolean(TAG_LOCKED, this.locked);
        if (this.display != null) {
            $$1.putString(TAG_DISPLAY, Component.Serializer.toJson(this.display, p_330377_));
        }
        if (this.numberFormat != null) {
            NumberFormatTypes.CODEC.encodeStart(p_330377_.createSerializationContext(NbtOps.INSTANCE), (Object)this.numberFormat).ifSuccess(p_313666_ -> $$1.put(TAG_FORMAT, (Tag)p_313666_));
        }
        return $$1;
    }

    public static Score read(CompoundTag p_313855_, HolderLookup.Provider p_331997_) {
        Score $$2 = new Score();
        $$2.value = p_313855_.getInt(TAG_SCORE);
        $$2.locked = p_313855_.getBoolean(TAG_LOCKED);
        if (p_313855_.contains(TAG_DISPLAY, 8)) {
            $$2.display = Component.Serializer.fromJson(p_313855_.getString(TAG_DISPLAY), p_331997_);
        }
        if (p_313855_.contains(TAG_FORMAT, 10)) {
            NumberFormatTypes.CODEC.parse(p_331997_.createSerializationContext(NbtOps.INSTANCE), (Object)p_313855_.get(TAG_FORMAT)).ifSuccess(p_313664_ -> {
                p_313663_.numberFormat = p_313664_;
            });
        }
        return $$2;
    }
}

